/*
 * Decompiled with CFR 0.152.
 */
package dev.lorenzz.registration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

final class PluginCommandFactory {
    PluginCommandFactory() {
    }

    public Command create(String name, Plugin plugin, String[] aliases, Executor executor, Completer completer) {
        return new DynamicCommand(name, Arrays.asList(aliases), executor, completer);
    }

    static final class DynamicCommand
    extends Command {
        private final Executor executor;
        private final Completer completer;

        DynamicCommand(String name, List<String> aliases, Executor executor, Completer completer) {
            super(name);
            this.setAliases(aliases);
            this.executor = executor;
            this.completer = completer;
        }

        public boolean execute(CommandSender sender, String commandLabel, String[] args) {
            if (this.executor == null) {
                return false;
            }
            return this.executor.execute(sender, commandLabel, args);
        }

        public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
            if (this.completer == null) {
                return Collections.emptyList();
            }
            List<String> result = this.completer.complete(sender, alias, args);
            return result == null ? Collections.emptyList() : result;
        }
    }

    @FunctionalInterface
    static interface Executor {
        public boolean execute(CommandSender var1, String var2, String[] var3);
    }

    @FunctionalInterface
    static interface Completer {
        public List<String> complete(CommandSender var1, String var2, String[] var3);
    }
}

