/*
 * Decompiled with CFR 0.152.
 */
package dev.lorenzz.provider;

import dev.lorenzz.exception.CommandExitException;
import dev.lorenzz.provider.Provider;
import dev.lorenzz.util.CommandUtils;
import dev.lorenzz.util.LanguageLocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class ProviderRegistry {
    private static final Map<Class<?>, Provider<?>> REGISTRY = new ConcurrentHashMap();

    private ProviderRegistry() {
    }

    public static <T> void register(Class<T> type, Provider<T> provider) {
        REGISTRY.put(type, provider);
    }

    public static <T> Provider<T> get(Class<T> type) {
        Provider<?> provider = REGISTRY.get(type);
        if (provider == null && type.isEnum()) {
            provider = ProviderRegistry.enumProvider(type);
            REGISTRY.put(type, provider);
        }
        return provider;
    }

    public static void registerDefaults() {
        ProviderRegistry.register(String.class, new Provider<String>(){

            @Override
            public String provide(String input) {
                return input;
            }

            @Override
            public List<String> tabComplete(CommandSender sender, String arg) {
                return Collections.emptyList();
            }
        });
        ProviderRegistry.register(Integer.class, ProviderRegistry.numeric(Integer::valueOf));
        ProviderRegistry.register(Integer.TYPE, ProviderRegistry.get(Integer.class));
        ProviderRegistry.register(Long.class, ProviderRegistry.numeric(Long::valueOf));
        ProviderRegistry.register(Long.TYPE, ProviderRegistry.get(Long.class));
        ProviderRegistry.register(Double.class, ProviderRegistry.numeric(Double::valueOf));
        ProviderRegistry.register(Double.TYPE, ProviderRegistry.get(Double.class));
        ProviderRegistry.register(Float.class, ProviderRegistry.numeric(Float::valueOf));
        ProviderRegistry.register(Float.TYPE, ProviderRegistry.get(Float.class));
        ProviderRegistry.register(Boolean.class, new Provider<Boolean>(){

            @Override
            public Boolean provide(String input) throws CommandExitException {
                if (input == null) {
                    throw new CommandExitException("Missing boolean");
                }
                if (input.equalsIgnoreCase("true") || input.equalsIgnoreCase("yes")) {
                    return true;
                }
                if (input.equalsIgnoreCase("false") || input.equalsIgnoreCase("no")) {
                    return false;
                }
                throw new CommandExitException(CommandUtils.colorize(LanguageLocale.INVALID_BOOLEAN.getString()));
            }

            @Override
            public List<String> tabComplete(CommandSender sender, String arg) {
                return Arrays.asList("true", "false");
            }
        });
        ProviderRegistry.register(Boolean.TYPE, ProviderRegistry.get(Boolean.class));
        ProviderRegistry.register(OfflinePlayer.class, new Provider<OfflinePlayer>(){

            @Override
            public OfflinePlayer provide(String input) throws CommandExitException {
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)input);
                if (player == null || !player.hasPlayedBefore() && !player.isOnline()) {
                    throw new CommandExitException(CommandUtils.colorize(LanguageLocale.PLAYER_NEVER_JOINED.getFormattedString(input)));
                }
                return player;
            }

            @Override
            public List<String> tabComplete(CommandSender sender, String arg) {
                return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
            }
        });
        ProviderRegistry.register(Player.class, new Provider<Player>(){

            @Override
            public Player provide(String input) throws CommandExitException {
                Player player = Bukkit.getPlayer((String)input);
                if (player == null) {
                    throw new CommandExitException(CommandUtils.colorize(LanguageLocale.PLAYER_NEVER_JOINED.getFormattedString(input)));
                }
                if (!player.isOnline()) {
                    throw new CommandExitException(CommandUtils.colorize(LanguageLocale.OFFLINE_PLAYER.getFormattedString(input)));
                }
                return player;
            }

            @Override
            public List<String> tabComplete(CommandSender sender, String arg) {
                return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
            }
        });
    }

    private static <N> Provider<N> numeric(final NumericParser<N> parser) {
        return new Provider<N>(){

            @Override
            public N provide(String input) throws CommandExitException {
                try {
                    return parser.parse(input);
                }
                catch (Exception ex) {
                    throw new CommandExitException(CommandUtils.colorize(LanguageLocale.INVALID_NUMBER.getFormattedString(input)));
                }
            }

            @Override
            public List<String> tabComplete(CommandSender sender, String arg) {
                return Collections.emptyList();
            }
        };
    }

    private static Provider<?> enumProvider(Class<?> type) {
        final Object[] constants = type.getEnumConstants();
        return new Provider<Enum<?>>(){

            @Override
            public Enum<?> provide(String input) throws CommandExitException {
                for (Object constant2 : constants) {
                    if (!((Enum)constant2).name().equalsIgnoreCase(input)) continue;
                    return (Enum)constant2;
                }
                throw new CommandExitException(CommandUtils.colorize(LanguageLocale.INVALID_ENUM.getFormattedString(input, String.join((CharSequence)", ", Arrays.stream(constants).map(constant -> ((Enum)constant).name().toLowerCase()).collect(Collectors.toList())))));
            }

            @Override
            public List<String> tabComplete(CommandSender sender, String arg) {
                ArrayList<String> list = new ArrayList<String>();
                for (Object constant : constants) {
                    list.add(((Enum)constant).name().toLowerCase(Locale.ROOT));
                }
                return list;
            }
        };
    }

    private static interface NumericParser<N> {
        public N parse(String var1) throws Exception;
    }
}

