/*
 * Decompiled with CFR 0.152.
 */
package dev.lorenzz.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PaginatedHelp {
    private final List<String> entries;
    private final int pageSize;

    public PaginatedHelp(List<String> entries, int pageSize) {
        this.entries = Collections.unmodifiableList(new ArrayList<String>(entries));
        this.pageSize = pageSize;
    }

    public int pages() {
        return Math.max(1, (int)Math.ceil((double)this.entries.size() / (double)this.pageSize));
    }

    public List<String> page(int index) {
        int page = Math.max(1, Math.min(index, this.pages()));
        int start = (page - 1) * this.pageSize;
        int end = Math.min(this.entries.size(), start + this.pageSize);
        return this.entries.subList(start, end);
    }
}

