/*
 * Decompiled with CFR 0.152.
 */
package dev.lorenzz.help;

import dev.lorenzz.annotations.Flag;
import dev.lorenzz.annotations.Hidden;
import dev.lorenzz.annotations.Named;
import dev.lorenzz.annotations.Optional;
import dev.lorenzz.annotations.Range;
import dev.lorenzz.annotations.Sender;
import dev.lorenzz.exception.CommandExitException;
import dev.lorenzz.help.PaginatedHelp;
import dev.lorenzz.util.CommandUtils;
import dev.lorenzz.util.LanguageLocale;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class HelpGenerator {
    private HelpGenerator() {
    }

    public static String usage(String root, String sub, String usage, Parameter[] parameters) {
        if (usage != null && !usage.trim().isEmpty()) {
            return CommandUtils.colorize(usage);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(root);
        if (sub != null && !sub.isEmpty()) {
            builder.append(" ").append(sub);
        }
        for (Parameter parameter : parameters) {
            String name;
            if (parameter.isAnnotationPresent(Hidden.class) || parameter.isAnnotationPresent(Sender.class)) continue;
            boolean optional = parameter.isAnnotationPresent(Optional.class);
            Named named = parameter.getAnnotation(Named.class);
            Flag flag = parameter.getAnnotation(Flag.class);
            String string = flag != null ? flag.value() : (name = named != null ? named.value() : parameter.getName());
            if (flag != null) {
                builder.append(" [").append(name).append("]");
                continue;
            }
            if (optional) {
                builder.append(" [").append(name).append("]");
                continue;
            }
            builder.append(" <").append(name).append(">");
        }
        return builder.toString();
    }

    public static PaginatedHelp subcommandHelp(String root, List<HelpEntry> entries) {
        entries.sort(Comparator.comparing(HelpEntry::label));
        ArrayList<String> lines = new ArrayList<String>();
        for (HelpEntry entry : entries) {
            lines.add(CommandUtils.colorize(entry.description().isEmpty() || entry.description().equalsIgnoreCase("N/A") ? LanguageLocale.HELP_COMMAND_ENTRY_NO_DESCRIPTION.getString().replace("<commandapi>", root).replace("<arguments>", entry.usage()) : LanguageLocale.HELP_COMMAND_ENTRY_DESCRIPTION.getString().replace("<commandapi>", root).replace("<arguments>", entry.usage()).replace("<description>", entry.description())));
            lines.add(CommandUtils.colorize("/" + root + entry.usage() + " - " + entry.description()));
        }
        return new PaginatedHelp(lines, 5);
    }

    public static void validateRanges(Parameter parameter, Object value) throws CommandExitException {
        Range range = parameter.getAnnotation(Range.class);
        if (range == null) {
            return;
        }
        if (value instanceof Number) {
            long v = ((Number)value).longValue();
            if (v < range.min()) {
                throw new CommandExitException(CommandUtils.colorize(LanguageLocale.INPUT_LOWER_THAN_MIN.getFormattedString(value)));
            }
            if (v > range.max()) {
                throw new CommandExitException(CommandUtils.colorize(LanguageLocale.INPUT_HIGHER_THAN_MAX.getFormattedString(value)));
            }
        }
    }

    public static class HelpEntry {
        private final String label;
        private final String usage;
        private final String description;

        public HelpEntry(String label, String usage, String description) {
            this.label = label;
            this.usage = usage;
            this.description = description;
        }

        public String label() {
            return this.label;
        }

        public String usage() {
            return this.usage;
        }

        public String description() {
            return this.description;
        }
    }
}

